-- new items *must* be added to the bottom of gItemStats, or they'll fuck up item IDs

--[[ string variables
	
	items can have some special "variables" in their name and description in brackets
	any unknown variable is replaced with a ?
	
	[COUNT] Show the item separated item count.
	[MONEY] Show an amount of money, interpreting the item count as an amount of quarters.
	[UNIQUE] Fire the "inventory:Text" event when translating the item.
	
]]
--[[ local events
	
	a few local events are used to facilitate the function of some items
	
	CLIENT
	
	inventory:Text("item_id", "unique_data", {text = "?"})
		modify "text" using the id and unique data table for the [UNIQUE] variable
	
	inventory:Draw("item_id", "unique_data", x, y, width, height, alpha)
		the item uses unique_drawing, and this is called right before the main texture is drawn
	
	inventory:Use(slot, "item_id", ["unique_data"])
		the player tried to use the item, return true to cancel and not actually "use" the item
	
	inventory:Equip([slot, "item_id", ["unique_data"])
		an item was equipped, or unequipped if no values are passed
	
	SERVER
	
	inventory:Use(player, "item_id", ["unique_data"], ["unique_data_sv"], slot)
		a player is just used an item
	
	inventory:Update(player)
		a player's inventory updated
	
]]
--[[ item stats
	
	id:                a unique identifier for the item
	name:              the friendly name shown for the item
	description:       the friendly description shown for the item
	max_count:         maximum count per instance, set to 1 for items that will use unique data tables
	can_drop:          if the client script will let players try to get rid of the item
	decay_hours:       (not implemented)
	icon_name:         the icon name (see cl_icons.lua), or "none"
	is_contraband:     (not implemented)
	can_have_multiple: if multiple "instances" of the item can be in a single inventory
	unique_drawing:    the item should fire the inventory:Draw event to draw behind its icon
	use_verb:          shown in inventory controls, disables the use button if nil
	use_cost:          how much it costs to "use" the item
	
]]

-- item list
gItemStats = {
	{ -- CAMERA (POLAROID) --
		-- Takes black and white pictures.
		id = "polaroid_camera",
		name = "Polaroid Camera",
		description = "Say cheese!",
		max_count = 1,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_camerapolaroid",
		is_contraband = false,
		can_have_multiple = false,
		unique_drawing = false,
		use_verb = "Equip",
		use_cost = 1,
	},
	{ -- PHOTOGRAPH --
		-- Can be viewed and framed until it expires.
		id = "photo",
		name = "Photograph",
		description = "[PHOTO DESCRIPTION]",
		max_count = 10,
		can_drop = true,
		decay_hours = 720,
		icon_name = "item_photograph",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = "View",
		use_cost = 1,
	},
	{ -- FILM --
		-- Used to save pictures taken as Photographs.
		id = "film",
		name = "Film",
		description = "Used for Camera.",
		max_count = 30,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_film",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = nil,
		use_cost = 1,
	},
	{ -- PICTURE FRAME --
		-- Saves picture from expiring, converts into Framed Picture.
		id = "picture_frame",
		name = "Picture Frame (Empty)",
		description = "Used to preserve Photos.",
		max_count = 10,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_framedpicture",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = nil,
		use_cost = 1,
	},
	{ -- FRAMED PICTURE --
		-- Can be viewed, and won't expire.
		id = "framed_picture",
		name = "Framed Picture",
		description = "[NAME OF PHOTO]",
		max_count = 10,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_framedpicture",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = "View",
		use_cost = 1,
	},
	{ -- CAMERA (DIGITAL) --
		-- Takes pictures in full color.
		id = "digital_camera",
		name = "Digital Camera",
		description = "Say cheese!",
		max_count = 1,
		can_drop = false,
		decay_hours = 0,
		icon_name = "item_cameradigital",
		is_contraband = false,
		can_have_multiple = false,
		unique_drawing = false,
		use_verb = "Equip",
		use_cost = 1,
	},
	{ -- BANANA --
		-- Replenishes health.
		id = "banana",
		name = "Banana",
		description = "Full of potassium.",
		max_count = 20,
		can_drop = true,
		decay_hours = 72,
		icon_name = "item_banana",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = "Eat",
		use_cost = 1,
	},
	{ -- SPOILED BANANA --
		-- Makes you throw up.
		id = "spoiled_banana",
		name = "Spoiled Banana",
		description = "Gross.",
		max_count = 20,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_bananaspoiled",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = "Eat",
		use_cost = 1,
	},
	{ -- WRISTWATCH --
		-- Displays the Clock when in Inventory.
		id = "wristwatch",
		name = "Wristwatch",
		description = "Got the time?",
		max_count = 20,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_watch",
		is_contraband = false,
		can_have_multiple = false,
		unique_drawing = false,
		use_verb = "Toggle",
		use_cost = 1,
	},
	{ -- BEAM COLA --
		-- Replenishes health.
		id = "beam_cola",
		name = "Beam Cola",
		description = "Sugar in a can.",
		max_count = 20,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_sodabeamcola",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = "Drink",
		use_cost = 1,
	},
	{ -- ACADEMY GIFT --
		-- Can be opened to give user items contained inside.
		id = "academy_gift",
		name = "Gift",
		description = "[GIFT DESCRIPTION]",
		max_count = 20,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_giftacademy",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = "Open",
		use_cost = 1,
	},
	{ -- GIFT WRAPPER --
		-- Allows user to put up to 3 items inside a Gift and select a gift icon of their choice.
		id = "gift_wrapper",
		name = "Gift Wrapper",
		description = "Put a pretty bow on it.",
		max_count = 20,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_giftwrapper",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = "Use",
		use_cost = 1,
	},
	{ -- APPLE --
		-- Replenishes health.
		id = "apple",
		name = "Apple",
		description = "One a day keep the doctor away.",
		max_count = 20,
		can_drop = true,
		decay_hours = 72,
		icon_name = "item_apple",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = "Eat",
		use_cost = 1,
	},
	{ -- SPOILED APPLE --
		-- Makes you throw up.
		id = "spoiled_apple",
		name = "Spoiled Apple",
		description = "Gross.",
		max_count = 20,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_applespoiled",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = "Eat",
		use_cost = 1,
	},
	{ -- GOLD TROPHY --
		-- Can be sold for a lot of money.
		id = "gold_trophy",
		name = "Gold Trophy",
		description = "First place!",
		max_count = 20,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_trophygold",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = nil,
		use_cost = 1,
	},
	{ -- SILVER TROPHY --
		-- Can be sold for a decent amount of money.
		id = "silver_trophy",
		name = "Silver Trophy",
		description = "Second place!",
		max_count = 20,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_trophysilver",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = nil,
		use_cost = 1,
	},
	{ -- BRONZE TROPHY --
		-- Can be sold for a little money.
		id = "bronze_trophy",
		name = "Bronze Trophy",
		description = "Third place!",
		max_count = 20,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_trophybronze",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = nil,
		use_cost = 1,
	},
	{ -- BLACK BAG --
		-- Mission item.
		id = "black_bag",
		name = "Black Bag",
		description = "I wonder what's inside.",
		max_count = 20,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_bagblack",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = nil,
		use_cost = 1,
	},
	{ -- BLUE BOOK --
		-- Mission item.
		id = "blue_book",
		name = "Blue Book",
		description = "Scientia est potentia!",
		max_count = 20,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_bookblue",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = nil,
		use_cost = 1,
	},
	{ -- MONEY --
		-- Hard coded to intelligently represent money, each item representing $0.25.
		id = "money",
		name = "Money",
		description = "Spend it wisely.",
		max_count = 8000,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_money",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = nil,
		use_cost = 1,
	},
	{ -- BOOZE --
		-- Makes player experience drunk effect, followed by a puking animation.
		id = "booze",
		name = "Bottle of Booze",
		description = "Liquid courage and terrible hangovers.",
		max_count = 20,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_bottle",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = "Drink",
		use_cost = 1,
	},
	{ -- BOTTLE ROCKET LAUNCHER --
		-- Bottle Rocket Launcher weapon.
		id = "bottle_rocket_launcher",
		name = "Bottle Rocket Launcher",
		description = "Light 'em up like the 4th of July!",
		max_count = 1,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_bottlerocketlauncher",
		is_contraband = true,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = "Equip",
		use_cost = 1,
	},
	{ -- GOLD CAR KEY --
		-- Keys to lock/unlock vehicle connected to the key.
		id = "gold_car_key",
		name = "Car Key",
		description = "Jingle jingle.",
		max_count = 1,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_carkeysgold",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = "Equip",
		use_cost = 0,
	},
	{ -- CHARACTER SHEET --
		-- Mission item.
		id = "character_sheet",
		name = "Character Sheet",
		description = "Grottos & Gremlins character sheet.",
		max_count = 20,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_charactersheet",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = nil,
		use_cost = 1,
	},
	{ -- CIGARETTES --
		-- Makes the player play a smoking animation.
		id = "cigarettes",
		name = "Cigarettes",
		description = "Smoking's cool.",
		max_count = 20,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_cigarettes",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = "Smoke",
		use_cost = 1,
	},
	{ -- DICE --
		-- Mission item.
		id = "dice",
		name = "Dice",
		description = "Dice for Grottos & Gremlins.",
		max_count = 20,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_dice",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = nil,
		use_cost = 1,
	},
	{ -- DOSSIER --
		-- Mission item.
		id = "dossier",
		name = "Dossier",
		description = "A folder full of incriminating evidence.",
		max_count = 20,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_dossier",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = nil,
		use_cost = 1,
	},
	{ -- BLUE DRESS --
		-- Mission item.
		id = "blue_dress",
		name = "Blue Dress",
		description = "A beautiful blue dress.",
		max_count = 20,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_dressblue",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = nil,
		use_cost = 1,
	},
	{ -- EGGS --
		-- Eggs weapon.
		id = "eggs",
		name = "Carton of Eggs",
		description = "These would make a great omelette.",
		max_count = 1,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_eggs",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = "Equip",
		use_cost = 1,
	},
	{ -- BLACK FLOWERS --
		-- Given to players who participated in a Halloween event.
		id = "black_flowers",
		name = "Black Flowers",
		description = "Thanks for participating in a Halloween event!",
		max_count = 20,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_flowersblack",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = nil,
		use_cost = 1,
	},
	{ -- BLUE FLOWERS --
		-- Given to Supporters.
		id = "blue_flowers",
		name = "Blue Flowers",
		description = "Thanks for playing Bully Online!",
		max_count = 20,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_flowersblue",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = nil,
		use_cost = 0,
	},
	{ -- PINK FLOWERS --
		-- Given to players to help out an admin by reporting a bug or solving a problem.
		id = "pink_flowers",
		name = "Pink Flowers",
		description = "Thanks for helping out an admin!",
		max_count = 20,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_flowerspink",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = nil,
		use_cost = 1,
	},
	{ -- RED FLOWERS --
		-- Regular flowers. Can be purchased at Yum Yum Market.
		id = "red_flowers",
		name = "Red Flowers",
		description = "Smells nice.",
		max_count = 20,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_flowersred",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = nil,
		use_cost = 1,
	},
	{ -- YELLOW FLOWERS --
		-- Given to players who participated in an Easter event.
		id = "yellow_flowers",
		name = "Yellow Flowers",
		description = "Thanks for participating in an Easter event!",
		max_count = 20,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_flowersyellow",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = nil,
		use_cost = 1,
	},
	{ -- FOOTBALL --
		-- Football weapon.
		id = "football",
		name = "Football",
		description = "Go long!",
		max_count = 1,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_football",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = "Equip",
		use_cost = 1,
	},
	{ -- SIGNED FOOTBALL --
		-- Mission item.
		id = "signed_football",
		name = "Signed Football",
		description = "Too bad they lost the game.",
		max_count = 20,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_footballsigned",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = nil,
		use_cost = 1,
	},
	{ -- G&G Cards --
		-- Mission item.
		id = "gg_card",
		name = "G&G Cards",
		description = "Grottos & Gremlins cards.",
		max_count = 20,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_ggcards",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = nil,
		use_cost = 1,
	},
	{ -- YUM YUM MARKET COUPON --
		-- Removes 20% of the cost of any item at Yum Yum Market.
		id = "yum_yum_coupon",
		name = "Yum Yum Market Coupon",
		description = "20% off any item at Yum Yum Market.",
		max_count = 20,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_ticketgreen",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = "Use",
		use_cost = 1,
	},
	{ -- SHINY BIKES COUPON --
		-- Removes 20% of the cost of any vehicle at Shiny Bikes (Tobias Mason Vehicle Dealer).
		id = "shiny_bikes_coupon",
		name = "Shiny Bikes Coupon",
		description = "20% off any vehicle at Shiny Bikes.",
		max_count = 20,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_ticketred",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = "Use",
		use_cost = 1,
	},
	{ -- DRAGON'S WING COUPON --
		-- Removes 20% of the cost of any item at Dragon's Wing.
		id = "dragons_wing_coupon",
		name = "Dragon's Wing Coupon",
		description = "20% off any item at Dragon's Wing.",
		max_count = 20,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_ticketblue",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = "Use",
		use_cost = 1,
	},
	{ -- BULLWORTH HAIR, NAIL & BEAUTY COUPON --
		-- Removes 20% of the cost of any character model at Bullworth Hair, Nail & Beauty.
		id = "hair_beauty_coupon",
		name = "Bullworth Beauty Coupon",
		description = "20% off any character at Bullworth Hair, Nail & Beauty.",
		max_count = 20,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_ticketpink",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = "Use",
		use_cost = 1,
	},
	{ -- RACING COUPON --
		-- Removes 20% of the cost of entering a race minigame.
		id = "racing_coupon",
		name = "Bully Online Racing Coupon",
		description = "20% off the cost of entering a race minigame.",
		max_count = 20,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_ticketyellow",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = "Use",
		use_cost = 1,
	},
	{ -- BLUE BAG --
		-- Mission item.
		id = "blue_bag",
		name = "Blue Bag",
		description = "I wonder what's inside.",
		max_count = 20,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_bagblue",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = nil,
		use_cost = 1,
	},
	{ -- RED BAG --
		-- Mission item.
		id = "red_bag",
		name = "Red Bag",
		description = "I wonder what's inside.",
		max_count = 20,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_bagred",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = nil,
		use_cost = 1,
	},
	{ -- YELLOW BAG --
		-- Mission item.
		id = "yellow_bag",
		name = "Yellow Bag",
		description = "I wonder what's inside.",
		max_count = 20,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_bagyellow",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = nil,
		use_cost = 1,
	},
	{ -- GREEN BAG --
		-- Mission item.
		id = "green_bag",
		name = "Yellow Bag",
		description = "I wonder what's inside.",
		max_count = 20,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_baggreen",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = nil,
		use_cost = 1,
	},
	{ -- AMERICA GIFT --
		-- Can be opened to give user items contained inside.
		id = "america_gift",
		name = "Gift",
		description = "[GIFT DESCRIPTION]",
		max_count = 20,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_giftamerica",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = "Open",
		use_cost = 1,
	},
	{ -- FINLAND GIFT --
		-- Can be opened to give user items contained inside.
		id = "finland_gift",
		name = "Gift",
		description = "[GIFT DESCRIPTION]",
		max_count = 20,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_giftfinland",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = "Open",
		use_cost = 1,
	},
	{ -- HALLOWEEN GIFT --
		-- Can be opened to give user items contained inside.
		id = "halloween_gift",
		name = "Gift",
		description = "[GIFT DESCRIPTION]",
		max_count = 20,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_gifthalloween",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = "Open",
		use_cost = 1,
	},
	{ -- IRELAND GIFT --
		-- Can be opened to give user items contained inside.
		id = "ireland_gift",
		name = "Gift",
		description = "[GIFT DESCRIPTION]",
		max_count = 20,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_giftireland",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = "Open",
		use_cost = 1,
	},
	{ -- NORMAL GIFT --
		-- Can be opened to give user items contained inside.
		id = "normal_gift",
		name = "Gift",
		description = "[GIFT DESCRIPTION]",
		max_count = 20,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_giftnormal",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = "Open",
		use_cost = 1,
	},
	{ -- SWEDEN GIFT --
		-- Can be opened to give user items contained inside.
		id = "sweden_gift",
		name = "Gift",
		description = "[UNIQUE]",
		max_count = 1,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_giftsweden",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = "Open",
		use_cost = 0,
	},
	{ -- GREEN BOOK --
		-- Mission item.
		id = "green_book",
		name = "Green Book",
		description = "Scientia est potentia!",
		max_count = 20,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_bookgreen",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = nil,
		use_cost = 1,
	},
	{ -- PINK BOOK --
		-- Mission item.
		id = "pink_book",
		name = "Pink Book",
		description = "Scientia est potentia!",
		max_count = 20,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_bookpink",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = nil,
		use_cost = 1,
	},
	{ -- RED BOOK --
		-- Mission item.
		id = "red_book",
		name = "Red Book",
		description = "Scientia est potentia!",
		max_count = 20,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_bookred",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = nil,
		use_cost = 1,
	},
	{ -- YELLOW BOOK --
		-- Mission item.
		id = "yellow_book",
		name = "Yellow Book",
		description = "Scientia est potentia!",
		max_count = 20,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_bookyellow",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = nil,
		use_cost = 1,
	},
	{ -- SILVER CAR KEY --
		-- Keys to lock/unlock vehicle connected to the key.
		id = "silver_car_key",
		name = "Car Key",
		description = "Jingle jingle.",
		max_count = 1,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_carkeyssilver",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = "Equip",
		use_cost = 0,
	},
	{ -- BRONZE CAR KEY --
		-- Keys to lock/unlock vehicle connected to the key.
		id = "bronze_car_key",
		name = "Car Key",
		description = "Jingle jingle.",
		max_count = 1,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_carkeysbronze",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = "Equip",
		use_cost = 0,
	},
	{ -- GREEN DRESS --
		-- Mission item.
		id = "green_dress",
		name = "Green Dress",
		description = "A beautiful green dress.",
		max_count = 20,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_dressgreen",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = nil,
		use_cost = 1,
	},
	{ -- PINK DRESS --
		-- Mission item.
		id = "pink_dress",
		name = "Pink Dress",
		description = "A beautiful pink dress.",
		max_count = 20,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_dresspink",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = nil,
		use_cost = 1,
	},
	{ -- RED DRESS --
		-- Mission item.
		id = "red_dress",
		name = "Red Dress",
		description = "A beautiful red dress.",
		max_count = 20,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_dressred",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = nil,
		use_cost = 1,
	},
	{ -- YELLOW DRESS --
		-- Mission item.
		id = "yellow_dress",
		name = "Yellow Dress",
		description = "A beautiful yellow dress.",
		max_count = 20,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_dressyellow",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = nil,
		use_cost = 1,
	},
	{ -- GLUE BOTTLE --
		-- Mission item.
		id = "glue_bottle",
		name = "Glue Bottle",
		description = "It's full of glue.",
		max_count = 20,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_gluebottle",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = nil,
		use_cost = 1,
	},
	{ -- YELLOW JACKET --
		-- Mission item.
		id = "yellow_jacket",
		name = "Yellow Jacket",
		description = "A fluffy yellow jacket.",
		max_count = 20,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_jacketyellow",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = nil,
		use_cost = 1,
	},
	{ -- GOLD HOUSE KEY --
		-- Keys to lock/unlock house connected to the key.
		id = "gold_house_key",
		name = "House Key",
		description = "Home sweet home.",
		max_count = 1,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_keygold",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = "Equip",
		use_cost = 0,
	},
	{ -- ASYLUM KEYCARD --
		-- Allows the player to open doors at the asylum and wander around without getting in trouble.
		id = "asylum_keycard",
		name = "Asylum Keycard",
		description = "Allows you to explore Happy Volts Asylum freely.",
		max_count = 20,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_keycardasylum",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = nil,
		use_cost = 1,
	},
	{ -- CHEMPLANT KEYCARD --
		-- Allows the player to open doors at the chemplant.
		id = "chemplant_keycard",
		name = "Chemplant Keycard",
		description = "Allows you to explore Chemplant freely.",
		max_count = 20,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_keycardchemplant",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = nil,
		use_cost = 1,
	},
	{ -- LETTER --
		-- Displays a message from the sender.
		id = "letter",
		name = "Letter",
		description = "I wonder what is says.",
		max_count = 20,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_letter",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = "Read",
		use_cost = 1,
	},
	{ -- LIPSTICK --
		-- Mission item.
		id = "lipstick",
		name = "Lipstick",
		description = "What do you think this stuff is made of?",
		max_count = 20,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_lipstick",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = nil,
		use_cost = 1,
	},
	{ -- ACADEMY MAGAZINE --
		-- Mission item.
		id = "academy_magazine",
		name = "Academy Magazine",
		description = "Hallway gossip rag.",
		max_count = 20,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_magazineacademy",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = nil,
		use_cost = 1,
	},
	{ -- COMIC BOOK --
		-- Mission item.
		id = "comic_book",
		name = "Comic Book",
		description = "The one where Personal Patriot and Death Robo team up against the evil Zarf.",
		max_count = 20,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_magazinecomicbook",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = nil,
		use_cost = 1,
	},
	{ -- TABLOID --
		-- Mission item.
		id = "tabloid",
		name = "Tabloid",
		description = "Huh. Madd Dogg is dating Candy Suxx now.",
		max_count = 20,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_magazinegazette",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = nil,
		use_cost = 1,
	},
	{ -- PUNK ROCK MAGAZINE --
		-- Mission item.
		id = "punk_rock_magazine",
		name = "Punk Rock Magazine",
		description = "Very underground. You probably haven't heard of it.",
		max_count = 20,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_magazinepunkrock",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = nil,
		use_cost = 1,
	},
	{ -- XXX MAGAZINE --
		-- Mission item.
		id = "xxx_magazine",
		name = "XXX Magazine",
		description = "It's for scientific research, I promise.",
		max_count = 20,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_magazinexxx",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = nil,
		use_cost = 1,
	},
	{ -- MEDICINE --
		-- Mission item.
		id = "medicine",
		name = "Medicine",
		description = "Cures what ails ya.",
		max_count = 20,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_medicine",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = nil,
		use_cost = 1,
	},
	{ -- GOLDEN NECKLACE --
		-- Mission item.
		id = "golden_necklace",
		name = "Golden Necklace",
		description = "Looks expensive.",
		max_count = 20,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_necklacegold",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = nil,
		use_cost = 1,
	},
	{ -- SILVER NECKLACE --
		-- Mission item.
		id = "silver_necklace",
		name = "Silver Necklace",
		description = "Fancy.",
		max_count = 20,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_necklacesilver",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = nil,
		use_cost = 1,
	},
	{ -- NEWSPAPER --
		-- Newspaper weapon.
		id = "newspaper",
		name = "Newspaper",
		description = "Extra! Extra!",
		max_count = 20,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_newspaper",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = nil,
		use_cost = 1,
	},
	{ -- PERFUME --
		-- Mission item.
		id = "perfume",
		name = "Perfume",
		description = "It has a hint of lavender and chemical burn.",
		max_count = 20,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_perfume",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = nil,
		use_cost = 1,
	},
	{ -- PHOTOS 1 --
		-- Mission item.
		id = "collectible_photos_a",
		name = "Collectible Photos A",
		description = "A collection of highly valued photos.",
		max_count = 20,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_photos1",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = nil,
		use_cost = 1,
	},
	{ -- PHOTOS 2 --
		-- Mission item.
		id = "collectible_photos_b",
		name = "Collectible Photos B",
		description = "A collection of highly valued photos.",
		max_count = 20,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_photos2",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = nil,
		use_cost = 1,
	},
	{ -- PHOTOS 3 --
		-- Mission item.
		id = "collectible_photos_c",
		name = "Collectible Photos C",
		description = "A collection of highly valued photos.",
		max_count = 20,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_photos3",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = nil,
		use_cost = 1,
	},
	{ -- PHOTOS 4 --
		-- Mission item.
		id = "collectible_photos_d",
		name = "Collectible Photos D",
		description = "A collection of highly valued photos.",
		max_count = 20,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_photos4",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = nil,
		use_cost = 1,
	},
	{ -- ANARCHY POSTER --
		-- Mission item.
		id = "anarchy_poster",
		name = "Anarchy Poster",
		description = "I hear they're dropping a new album soon.",
		max_count = 20,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_posteranarchy",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = nil,
		use_cost = 1,
	},
	{ -- BULLWORTH BULLS POSTER --
		-- Mission item.
		id = "bullworth_bullhorns_poster",
		name = "Bullworth Bullhorns Poster",
		description = "YEAH! BULLWORTH! GO BULLWORTH!",
		max_count = 20,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_posterbullworthbulls",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = nil,
		use_cost = 1,
	},
	{ -- CHEERLEADER POSTER --
		-- Mission item.
		id = "cheerleader_poster",
		name = "Cheerleader Poster",
		description = "I guess Beatrice didn't make the squad.",
		max_count = 20,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_postercheerleader",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = nil,
		use_cost = 1,
	},
	{ -- OG LOC POSTER --
		-- Mission item.
		id = "og_loc_poster",
		name = "OG Loc Poster",
		description = "Down, with a frown, on the town, a sad clown!",
		max_count = 20,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_posterogloc",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = nil,
		use_cost = 1,
	},
	{ -- ROCKSTAR GAMES POSTER --
		-- Mission item.
		id = "rockstar_games_poster",
		name = "Rockstar Games Poster",
		description = "Some games deserve a sequel more than others.",
		max_count = 20,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_posterrockstar",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = nil,
		use_cost = 1,
	},
	{ -- RUBBERBAND --
		-- Mission item.
		id = "rubberband",
		name = "Rubberband",
		description = "Why's this stuff lying around everywhere?",
		max_count = 20,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_rubberband",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = nil,
		use_cost = 1,
	},
	{ -- RUBBERBAND BALL --
		-- Rubberband ball weapon.
		id = "rubberbandball",
		name = "Rubberband Ball",
		description = "Surprisingly dangerous is close quarters.",
		max_count = 1,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_rubberbandball",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = "Equip",
		use_cost = 1,
	},
	{ -- BLUE SHIRT --
		-- Mission item.
		id = "blue_shirt",
		name = "Blue Shirt",
		description = "A fancy blue shirt.",
		max_count = 20,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_shirtblue",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = nil,
		use_cost = 1,
	},
	{ -- GREEN SHIRT --
		-- Mission item.
		id = "green_shirt",
		name = "Green Shirt",
		description = "A fancy green shirt.",
		max_count = 20,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_shirtgreen",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = nil,
		use_cost = 1,
	},
	{ -- PINK SHIRT --
		-- Mission item.
		id = "pink_shirt",
		name = "Pink Shirt",
		description = "A fancy pink shirt.",
		max_count = 20,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_shirtpink",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = nil,
		use_cost = 1,
	},
	{ -- RED SHIRT --
		-- Mission item.
		id = "red_shirt",
		name = "Red Shirt",
		description = "A fancy red shirt.",
		max_count = 20,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_shirtred",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = nil,
		use_cost = 1,
	},
	{ -- YELLOW SHIRT --
		-- Mission item.
		id = "yellow_shirt",
		name = "Yellow Shirt",
		description = "A fancy yellow shirt.",
		max_count = 20,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_shirtyellow",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = nil,
		use_cost = 1,
	},
	{ -- SHOVEL --
		-- Mission item.
		id = "shovel",
		name = "Shovel",
		description = "A fancy yellow shirt.",
		max_count = 20,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_shovel",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = nil,
		use_cost = 1,
	},
	{ -- SLINGSHOT --
		-- Slingshot weapon.
		id = "slingshot",
		name = "Slingshot",
		description = "The preferred weapon of bullies everywhere.",
		max_count = 1,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_slingshot",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = "Equip",
		use_cost = 1,
	},
	{ -- SUPER SLINGSHOT --
		-- Super Slingshot weapon.
		id = "super_slingshot",
		name = "Super Slingshot",
		description = "Like a normal slingshot, but better and with a scope!",
		max_count = 1,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_slingshotsuper",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = "Equip",
		use_cost = 1,
	},
	{ -- SOCCERBALL --
		-- Soccerball weapon.
		id = "soccerball",
		name = "Soccerball",
		description = "Does Bullworth even have a soccer team?",
		max_count = 1,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_soccerball",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = "Equip",
		use_cost = 1,
	},
	{ -- PEELZA POP --
		-- Replenishes stamina.
		id = "peelza_pop",
		name = "Peelza Pop",
		description = "PURE. LIQUID. CAFFEINE.",
		max_count = 20,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_sodapeelzapop",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = "Drink",
		use_cost = 1,
	},
	{ -- SPRAYCAN --
		-- Spraycan weapon.
		id = "spraycan",
		name = "Spraycan",
		description = "Useful for marking your territory.",
		max_count = 1,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_spraycan",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = "Equip",
		use_cost = 1,
	},
	{ -- SPUDGUN --
		-- Spudgun weapon.
		id = "spudgun",
		name = "Spudgun",
		description = "Flight of the potatoes!",
		max_count = 1,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_spudgun",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = "Equip",
		use_cost = 1,
	},
	{ -- STINKBOMB --
		-- Stinkbomb weapon.
		id = "stinkbomb",
		name = "Stinkbomb",
		description = "Somehow smells even worse than Algie's locker.",
		max_count = 1,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_stinkbomb",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = "Equip",
		use_cost = 1,
	},
	{ -- TEDDYBEAR --
		-- Mission item.
		id = "teddybear",
		name = "Teddybear",
		description = "Not exactly Cobrastyle.",
		max_count = 20,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_teddybear",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = nil,
		use_cost = 1,
	},
	{ -- VOICE CHANGER --
		-- Mission item.
		id = "voice_changer",
		name = "Voice Changer",
		description = "Mic check, one-two!",
		max_count = 20,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_voicechanger",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = nil,
		use_cost = 1,
	},
	{ -- ITCHING POWDER --
		-- Itching Powder weapon.
		id = "itching_powder",
		name = "Itching Powder",
		description = "Happiness is having a scratch for every itch.",
		max_count = 1,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_itchingpowder",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = "Equip",
		use_cost = 1,
	},
	{ -- SKATEBOARD --
		-- Skateboard weapon.
		id = "skateboard",
		name = "Skateboard",
		description = "Tony Hawk would be pleased.",
		max_count = 1,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_skateboard",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = "Equip",
		use_cost = 0,
	},
	{ -- BLUE JACKET --
		-- Mission item.
		id = "blue_jacket",
		name = "Blue Jacket",
		description = "A fluffy blue jacket.",
		max_count = 20,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_jacketblue",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = nil,
		use_cost = 1,
	},
	{ -- GREEN JACKET --
		-- Mission item.
		id = "green_jacket",
		name = "Green Jacket",
		description = "A fluffy green jacket.",
		max_count = 20,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_jacketgreen",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = nil,
		use_cost = 1,
	},
	{ -- PINK JACKET --
		-- Mission item.
		id = "pink_jacket",
		name = "Pink Jacket",
		description = "A fluffy pink jacket.",
		max_count = 20,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_jacketpink",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = nil,
		use_cost = 1,
	},
	{ -- RED JACKET --
		-- Mission item.
		id = "red_jacket",
		name = "Red Jacket",
		description = "A fluffy red jacket.",
		max_count = 20,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_jacketred",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = nil,
		use_cost = 1,
	},
	{ -- WHACKY GIFT --
		-- Can be opened to give user items contained inside.
		id = "whacky_gift",
		name = "Gift",
		description = "[GIFT DESCRIPTION]",
		max_count = 20,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_giftwhacky",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = "Open",
		use_cost = 1,
	},
	{ -- BLANK PAPER --
		-- Can be used to create a written paper.
		id = "blank_paper",
		name = "Paper",
		description = "A blank piece of paper.",
		max_count = 20,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_paperblank",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = "Write",
		use_cost = 0,
	},
	{ -- WRITTEN PAPER --
		-- Contains a note from a user.
		id = "written_paper",
		name = "Note",
		description = "[UNIQUE]",
		max_count = 1,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_paperwritten",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = "Read",
		use_cost = 0,
	},
	{ -- TUNGSTEN CUBE --
		-- A fucking tungsten cube!!!
		id = "tungsten_cube",
		name = "4\" Tungsten Cube",
		description = "A 4 inch cube of solid tungsten.",
		max_count = 1,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_tungsten",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = nil,
		use_cost = 1,
	},
	{ -- SILVER HOUSE KEY --
		-- Keys to lock/unlock house connected to the key.
		id = "silver_house_key",
		name = "House Key",
		description = "Home sweet home.",
		max_count = 1,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_keysilver",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = "Equip",
		use_cost = 0,
	},
	{ -- BRONZE HOUSE KEY --
		-- Keys to lock/unlock house connected to the key.
		id = "bronze_house_key",
		name = "House Key",
		description = "Home sweet home.",
		max_count = 1,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_keybronze",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = "Equip",
		use_cost = 0,
	},
	{ -- GOLD LOCKER KEY --
		-- Keys to lock/unlock locker connected to the key.
		id = "gold_locker_key",
		name = "Locker Key",
		description = "Shouldn't this be called an un-locker?",
		max_count = 1,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_lockerkeygold",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = "Equip",
		use_cost = 0,
	},
	{ -- SILVER LOCKER KEY --
		-- Keys to lock/unlock locker connected to the key.
		id = "silver_locker_key",
		name = "Locker Key",
		description = "Shouldn't this be called an un-locker?",
		max_count = 1,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_lockerkeysilver",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = "Equip",
		use_cost = 0,
	},
	{ -- BRONZE LOCKER KEY --
		-- Keys to lock/unlock locker connected to the key.
		id = "bronze_locker_key",
		name = "Locker Key",
		description = "Shouldn't this be called an un-locker?",
		max_count = 1,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_lockerkebronze",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = "Equip",
		use_cost = 0,
	},
	{ -- BAG OF PEBBLES --
		-- Ammo for the Slingshot and Super Slingshot.
		id = "bag_of_pebbles",
		name = "Bag of Pebbles",
		description = "Lock n' load your Slingshot with these bad boys.",
		max_count = 30,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_bagofpebbles",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = nil,
		use_cost = 0,
	},
	{ -- BASEBALL BAT --
		-- Baseball bat weapon.
		id = "baseball_bat",
		name = "Baseball Bat",
		description = "Batter up!",
		max_count = 1,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_baseballbat",
		is_contraband = true,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = "Equip",
		use_cost = 0,
	},
	{ -- BASKETBALL --
		-- Basketball weapon.
		id = "basketball",
		name = "Basketball",
		description = "No traveling!",
		max_count = 1,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_basketball",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = "Equip",
		use_cost = 0,
	},
	{ -- BOTTLE ROCKETS --
		-- Bottle Rockets ammo.
		id = "bottlerockets",
		name = "Bottle Rockets",
		description = "Ammunition for the Bottle Rocket Launcher.",
		max_count = 15,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_bottlerockets",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = nil,
		use_cost = 0,
	},
	{ -- CARTON OF MILK --
		-- Mission item.
		id = "milk",
		name = "Carton of Milk",
		description = "It's from a cow, right...?",
		max_count = 20,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_milk",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = nil,
		use_cost = 0,
	},
	{ -- BRICK --
		-- Brick.
		id = "brick",
		name = "Brick",
		description = "Useful for building a wall and for putting someone in the infirmary.",
		max_count = 10,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_brick",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = "Equip",
		use_cost = 0,
	},
	{ -- CAN OF SPUDS --
		-- Ammo for the Spudgun.
		id = "spuds",
		name = "Can of Spuds",
		description = "Ammunition for the Spudgun.",
		max_count = 15,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_spuds",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = nil,
		use_cost = 0,
	},
	{ -- CRICKET BAT --
		-- Cricket bat weapon.
		id = "cricket_bat",
		name = "Cricket Bat",
		description = "After the game, we'll have a nice cold pint and wait for all this to blow over.",
		max_count = 1,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_cricketbat",
		is_contraband = true,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = "Equip",
		use_cost = 0,
	},
	{ -- MENTHOL CIGARETTES --
		-- Makes the player play a smoking animation.
		id = "cigarettes_menthol",
		name = "Menthol Cigarettes",
		description = "Smoking's cool.",
		max_count = 20,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_cigarettesmenthol",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = "Smoke",
		use_cost = 1,
	},
	{ -- BLACK PANTS --
		-- Mission item.
		id = "pants_black",
		name = "Black Pants",
		description = "A pair of stylish black pants.",
		max_count = 20,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_pantsblack",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = nil,
		use_cost = 1,
	},
	{ -- BLUE PANTS --
		-- Mission item.
		id = "pants_blue",
		name = "Blue Pants",
		description = "A pair of stylish blue pants.",
		max_count = 20,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_pantsblue",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = nil,
		use_cost = 1,
	},
	{ -- BROWN PANTS --
		-- Mission item.
		id = "pants_brown",
		name = "Brown Pants",
		description = "A pair of stylish brown pants.",
		max_count = 20,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_pantsbrown",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = nil,
		use_cost = 1,
	},
	{ -- GREY PANTS --
		-- Mission item.
		id = "pants_grey",
		name = "Grey Pants",
		description = "A pair of stylish grey pants.",
		max_count = 20,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_pantsgrey",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = nil,
		use_cost = 1,
	},
	{ -- WHITE PANTS --
		-- Mission item.
		id = "pants_white",
		name = "White Pants",
		description = "A pair of stylish white pants.",
		max_count = 20,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_pantswhite",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = nil,
		use_cost = 1,
	},
	{ -- RIGGED FOOTBALL --
		-- Rigged Football weapon.
		id = "football_rigged",
		name = "Rigged Football",
		description = "Go long!",
		max_count = 1,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_footballrigged",
		is_contraband = true,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = "Equip",
		use_cost = 1,
	},
	{ -- BLACK SNEAKERS --
		-- Mission item.
		id = "sneakers_black",
		name = "Black Sneakers",
		description = "A pair of ergonomic black sneakers.",
		max_count = 20,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_sneakersblack",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = nil,
		use_cost = 1,
	},
	{ -- BLUE SNEAKERS --
		-- Mission item.
		id = "sneakers_blue",
		name = "Blue Sneakers",
		description = "A pair of ergonomic blue sneakers.",
		max_count = 20,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_sneakersblue",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = nil,
		use_cost = 1,
	},
	{ -- BROWN SNEAKERS --
		-- Mission item.
		id = "sneakers_brown",
		name = "Brown Sneakers",
		description = "A pair of ergonomic brown sneakers.",
		max_count = 20,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_sneakersbrown",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = nil,
		use_cost = 1,
	},
	{ -- GREY SNEAKERS --
		-- Mission item.
		id = "sneakers_grey",
		name = "Grey Sneakers",
		description = "A pair of ergonomic grey sneakers.",
		max_count = 20,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_sneakersgrey",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = nil,
		use_cost = 1,
	},
	{ -- WHITE SNEAKERS --
		-- Mission item.
		id = "sneakers_white",
		name = "White Sneakers",
		description = "A pair of ergonomic white sneakers.",
		max_count = 20,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_sneakerswhite",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = nil,
		use_cost = 1,
	},
	{ -- SUPER SPUDGUN --
		-- Spudgun weapon.
		id = "spudgunsuper",
		name = "Super Spudgun",
		description = "Flight of the potatoes!",
		max_count = 1,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_spudgunsuper",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = "Equip",
		use_cost = 1,
	},
	{ -- V1 RELEASE NOTE --
		-- Note given to all new players after Bully Online V1 Release in December of 2025.
		id = "note_v1rel",
		name = "Bully Online Note",
		description = "A message from the developers! You better read it.",
		max_count = 1,
		can_drop = true,
		decay_hours = 0,
		icon_name = "item_paperwritten_v1rel",
		is_contraband = false,
		can_have_multiple = true,
		unique_drawing = false,
		use_verb = "Read",
		use_cost = 0,
	},
}

-- items by id
gItemIndex = {}
for index,stats in ipairs(gItemStats) do
	if gItemIndex[stats.id] then
		PrintWarning("duplicate item id: item #"..index)
	end
	gItemIndex[stats.id] = index
end
